% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizeRcode.R
\name{OptimizeRcode}
\alias{OptimizeRcode}
\title{Optimize and Complete R Code}
\usage{
OptimizeRcode(
  Model = "gpt-4o-mini",
  SelectedCode = TRUE,
  verbose = TRUE,
  verbose_Reasons4change = FALSE,
  SlowTone = FALSE
)
}
\arguments{
\item{Model}{A string specifying the machine learning model to use for code optimization. Default is "gpt-4o-mini".}

\item{SelectedCode}{A boolean indicating whether to get the code from RStudio or the clipboard. Default is TRUE.}

\item{verbose}{A logical value indicating whether to print the result to the console, default is TRUE.}

\item{verbose_Reasons4change}{A boolean indicating whether to provide detailed reasons for the changes made. Default is FALSE}

\item{SlowTone}{A boolean indicating whether to print the output slowly. Default is FALSE.}
}
\value{
A message indicating the completion of the optimization process.
}
\description{
Optimizes and completes the R code from the selected code or clipboard.
}
\details{
Optimize and Complete R Code

This function takes a snippet of R code and optimizes it for performance and readability.
It uses a machine learning model to generate the optimized code.
}
\examples{
\dontrun{
#Copy your R code then run the following function.
OptimizeRcode(SelectedCode = FALSE)
}
}
\author{
Satoshi Kume
}
