% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as_vector.checkglobalsi}
\alias{as_vector.checkglobalsi}
\title{Cast to list vector}
\usage{
\method{as_vector}{checkglobalsi}(x, pattern, ...)
}
\arguments{
\item{x}{object inheriting from class \code{"checkglobalsi"}.}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{...}{additional arguments to configure the output:
\itemize{
\item \code{all.names}, a logical value.  If \code{TRUE}, all object names are returned.
If \code{FALSE}, names which begin with a \samp{.} are omitted. Defaults to \code{TRUE}.
\item \code{sorted}, a logical value indicating if the function/variable names should be sorted alphabetically.
Defaults to \code{TRUE}.
}}
}
\value{
a list consisting of two character vectors:
\itemize{
\item \code{import}, vector of import function/variable names.
\item \code{package}, vector of import package names.
}
}
\description{
Cast an S3-object of class \code{"checkglobalsi"} to a list vector.
}
\examples{
## R-package from folder
chk <- checkglobals(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)
as_vector(chk$imports)
}
\seealso{
\code{\link{as_vector.checkglobals}}
}
