% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifiers.R
\name{exactly_equal}
\alias{exactly_equal}
\title{Facilitate "Exactly Equal" Comparison on Logical Vectors}
\usage{
exactly_equal(logical_vec, p = NULL, n = NULL, na.rm = FALSE)
}
\arguments{
\item{logical_vec}{A logical vector.}

\item{p}{Proportion value (0 to 1) to compare against.}

\item{n}{Count value (integer) to compare against.}

\item{na.rm}{Logical. Should missing values be removed before calculation?}
}
\value{
\code{TRUE} if the proportion or count of values is exactly equal to
the specified value, otherwise \code{FALSE}.
}
\description{
This function facilitates a comparison to check if the proportion or count
of values in a logical vector is exactly equal to a specified value.
}
\examples{
# Check if all values are TRUE
exactly_equal(c(TRUE, TRUE, TRUE), p = 1.0) # Returns TRUE

}
\seealso{
Other basic_quantifiers: 
\code{\link{at_least}()},
\code{\link{at_most}()},
\code{\link{less_than}()},
\code{\link{more_than}()}
}
\concept{basic_quantifiers}
