% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifiers.R
\name{more_than}
\alias{more_than}
\title{Facilitate "More Than" Comparison on Logical Vectors}
\usage{
more_than(logical_vec, p = NULL, n = NULL, na.rm = FALSE)
}
\arguments{
\item{logical_vec}{A logical vector.}

\item{p}{Proportion value (0 to 1) to compare against.}

\item{n}{Count value (integer) to compare against.}

\item{na.rm}{Logical. Should missing values be removed before calculation?}
}
\value{
\code{TRUE} if the condition is met for more than the specified
proportion or count, otherwise \code{FALSE}.
}
\description{
This function facilitates a comparison to check if more than a specified
proportion or count of values in a logical vector evaluate to \code{TRUE}.
}
\examples{
# Check if more than 70\% of values are TRUE
more_than(c(TRUE, TRUE, FALSE, TRUE), p = 0.7) # Returns TRUE

}
\seealso{
Other basic_quantifiers: 
\code{\link{at_least}()},
\code{\link{at_most}()},
\code{\link{exactly_equal}()},
\code{\link{less_than}()}
}
\concept{basic_quantifiers}
