% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-typechecks.R
\name{validate_count}
\alias{validate_count}
\title{Validate a Count Value}
\usage{
validate_count(x, include_zero = TRUE)
}
\arguments{
\item{x}{Numeric value to validate as a count.}

\item{include_zero}{Logical, whether to include zero as a valid count.}
}
\value{
\code{TRUE} if \code{x} is a valid count, otherwise it throws an
error.
}
\description{
This function validates whether a numeric value is a valid count (integer of
zero or greater).
}
\examples{
validate_count(0) # TRUE
validate_count(3) # TRUE
try(validate_count(0, include_zero = FALSE)) # Error: Not a valid count
try(validate_count(-1)) # Error: Not a valid count value.
}
\seealso{
\code{\link{is_count}}, \code{\link{is_proportion}},
\code{\link{validate_proportion}}, \code{\link{is_integerlike}}
}
