% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_edge_lists.R
\name{append_edge_lists}
\alias{append_edge_lists}
\title{Append several edge lists}
\usage{
append_edge_lists(...)
}
\arguments{
\item{...}{one or several edge lists \code{data.frame}. Outputs of the function
\code{\link[=create_edge_list]{create_edge_list()}}.}
}
\value{
A \code{data.frame} with \code{n} rows (where \code{n} is the total number of edges)
and the following two columns:
\itemize{
\item \code{from}: the node label of one of the two endpoints of the edge
\item \code{to}: the node label of the other endpoint of the edge
}
}
\description{
Appends several edge lists created by \code{\link[=create_edge_list]{create_edge_list()}}. Merged edges
will be ordered and duplicates will be removed.
}
\examples{
library("chessboard")

# Two-dimensional sampling (only) ----
sites_infos <- expand.grid("transect" = 1:3, "quadrat" = 1:5)

nodes <- create_node_labels(data     = sites_infos, 
                            transect = "transect", 
                            quadrat  = "quadrat")

edges_1 <- create_edge_list(nodes, method = "pawn", directed = TRUE)
edges_2 <- create_edge_list(nodes, method = "bishop", directed = TRUE)

edges <- append_edge_lists(edges_1, edges_2)
}
