% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_weights_matrix.R
\name{spatial_weights_matrix}
\alias{spatial_weights_matrix}
\title{Create a spatial weights matrix}
\usage{
spatial_weights_matrix(x, y)
}
\arguments{
\item{x}{an adjacency \code{matrix} of dimensions \verb{n x n}, where \code{n} is the
number of nodes (sites). The output of \code{\link[=connectivity_matrix]{connectivity_matrix()}}.}

\item{y}{an edges weight \code{matrix} of dimensions \verb{n x n}, where \code{n} is the
number of nodes (sites). The output of \code{\link[=edges_weights_matrix]{edges_weights_matrix()}}.}
}
\value{
A spatial weights \code{matrix} of dimensions \verb{n x n}, where \code{n} is the
number of nodes (sites).
}
\description{
Creates a spatial weights matrix by multiplying an adjacency (connectivity)
matrix (see \code{\link[=connectivity_matrix]{connectivity_matrix()}}) and an edges weights matrix (see
\code{\link[=edges_weights_matrix]{edges_weights_matrix()}}). Resulting spatial weights equal to 0 will be
replaced by \verb{4 x max(w)}, where \code{max(w)} is the maximal weight in the
matrix.
}
\examples{
# Import Adour sites ----
path_to_file <- system.file("extdata", "adour_survey_sampling.csv", 
                            package = "chessboard")
adour_sites <- read.csv(path_to_file)

# Select the 15 first sites ----
adour_sites <- adour_sites[1:15, ]

# Create node labels ----
adour_sites <- create_node_labels(adour_sites, 
                                  location = "location", 
                                  transect = "transect", 
                                  quadrat  = "quadrat")

# Create edges based on the pawn move (directed network) ----
adour_edges <- create_edge_list(adour_sites, method = "pawn", 
                                directed = TRUE)

# Get connectivity matrix ----
adour_adjacency <- connectivity_matrix(adour_edges)

# Convert sites to sf object (POINTS) ----
adour_sites_sf <- sf::st_as_sf(adour_sites, 
                               coords = c("longitude", "latitude"),
                               crs = "epsg:2154")

# Compute distances between pairs of sites along the Adour river ----
adour_dists <- distance_euclidean(adour_sites_sf)

# Create Edges weights matrix ----
adour_weights <- edges_weights_matrix(adour_dists)

# Create Spatial weights matrix ----
spatial_weights_matrix(adour_adjacency, adour_weights)
}
