% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waters_arw.R
\name{read_waters_arw}
\alias{read_waters_arw}
\title{Read 'Waters' ASCII (.arw)}
\usage{
read_waters_arw(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw")
)
}
\arguments{
\item{path}{Path to Waters \code{.arw} file.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{read_metadata}{Whether to read metadata from file.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}
}
\value{
A chromatogram in the format specified by \code{format_out}
(retention time x wavelength).
}
\description{
Reads 'Waters' ASCII \code{.arw} files.
}
\details{
For help exporting files from Empower, you can consult the official
documentation: \href{https://support.waters.com/KB_Inf/Empower_Breeze/WKB77571_How_to_export_3D_raw_data_from_Empower_to_a_Microsoft_Excel_spreadsheet}{How_to_export_3D_raw_data_from_Empower}.
}
\seealso{
Other 'Waters' parsers: 
\code{\link{read_waters_raw}()}
}
\author{
Ethan Bass
}
\concept{'Waters' parsers}
