% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_ci_diff.R
\name{ci_prop_diff_wald}
\alias{ci_prop_diff_wald}
\title{Wald Confidence Interval for Difference in Proportions}
\usage{
ci_prop_diff_wald(x, by, conf.level = 0.95, correct = FALSE, data = NULL)
}
\arguments{
\item{x}{(\code{binary}/\code{numeric}/\code{logical})\cr
vector of a binary values, i.e. a logical vector, or numeric with values \code{c(0, 1)}}

\item{by}{(\code{string}) \cr A character or factor vector with exactly two unique levels
identifying the two groups to compare. Can also be a column name if a data
frame provided in the \code{data} argument.}

\item{conf.level}{(\verb{scalar numeric}) \cr a scalar in (0,1) indicating the confidence level. Default is 0.95}

\item{correct}{(\code{logical})\cr apply continuity correction.}

\item{data}{(\code{data.frame}) \cr Optional data frame containing the variables specified in \code{x} and \code{by}.}
}
\value{
An object containing the following components:
\item{n}{Number of responses in each by group}
\item{N}{Total number in each by group}
\item{estimate}{The point estimate of the difference in proportions (p_1 - p_2)}
\item{conf.low}{Lower bound of the confidence interval}
\item{conf.high}{Upper bound of the confidence interval}
\item{conf.level}{The confidence level used}
\item{method}{Type of method used}
}
\description{
Calculates the Wald interval by following the usual textbook definition
for a difference in proportions confidence interval using the normal approximation.
}
\details{
\deqn{(\hat{p}_1 - \hat{p}_2) \pm z_{\alpha/2}
\sqrt{\frac{\hat{p}_1(1 - \hat{p}_1)}{n_1}+\frac{\hat{p}_2(1 - \hat{p}_2)}{n_2}}}
}
\examples{
responses <- expand(c(9, 3), c(10, 10))
arm <- rep(c("treat", "control"), times = c(10, 10))

# Calculate 95\% confidence interval for difference in proportions
ci_prop_diff_wald(x = responses, by = arm)
}
