% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{remove_cardinal_biases_discrete}
\alias{remove_cardinal_biases_discrete}
\title{Remove cardinal biases for data with orientation (color, motion, ...) set in discrete steps}
\usage{
remove_cardinal_biases_discrete(err, x, space, init_outliers = NULL)
}
\arguments{
\item{err}{a vector of errors, deviations of response from the true stimuli}

\item{x}{a vector of true stimuli in degrees (see space)}

\item{space}{circular space to use (a string: \code{180} or \code{360})}

\item{init_outliers}{a vector determining which errors are initially assumed to be outliers (default: NULL)}
}
\value{
returns a data.table with the following columns:
\itemize{
\item is_outlier - 0 for outliers (defined as ±3*predicted SD, where SD and mean are computed after excluding initially assumed outliers)
\item be_c error corrected for biases (\verb{be_c = observed error - pred})
}
}
\description{
Remove cardinal biases for data with orientation (color, motion, ...) set in discrete steps
}
