% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_refs.R
\name{get_refs}
\alias{get_refs}
\title{Automated citation chasing in systematic reviews}
\usage{
get_refs(article_list, type = "doi", get_records, save_object = FALSE, token)
}
\arguments{
\item{article_list}{List of article identifiers for which the reference
lists will be returned. Must be a list/vector of identifiers, e.g.
'"10.1186/s13750-018-0126-2" "10.1002/jrsm.1378"'.}

\item{type}{Specification of the type of input provided. The default is
'doi' (digital object identifier), but any of the following are accepted:
"pmid" (PubMed ID), "pmcid" (PubMed Central ID), "magid" (Microsoft
Academic ID), "coreid" (CORE identifier), lens_id" (The Lens.org ID),
"title" (article title; much lower specificity).}

\item{get_records}{Specification of whether to look for records referenced
within the input articles ('references'), records citing the input articles
('citations'), or both ('both').}

\item{save_object}{Option to save the resultant ris file as an object in
the Global Environment. The default is FALSE.}

\item{token}{An access key for the lens.org API. Tokens can be obtained by
applying for scholarly API access and creating a token once approved. See
'https://www.lens.org/lens/user/subscriptions#scholar' for further details.}
}
\value{
An RIS file is saved to the working directory. A report is printed
to the console. If 'save_object=TRUE', the RIS file is returned as an
object
}
\description{
This function takes a list of articles in the form of established
identifiers (e.g. digital object identifiers) and sends a request to the
lens.org API to firstly identify all cited references in all articles (in the
form of lists of lens IDs), and then query these lens IDs to bring back full
citation information for all listed records. Deduplicates references to the
same records across articles, resulting in an RIS file and a summary report
in the console.
}
\examples{
\dontrun{
article_list <- c("10.1007/978-3-642-37048-9_13", 
                  "10.1111/sum.12030", 
                  "10.5194/bg-13-3619-2016", 
                  "10.1016/j.agee.2012.09.006")
  token <- 'token'
  refs <- get_refs(article_list, get_records = 'references', token = token)
  refs
  }
}
