% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciu.plots.R
\name{ciu.plots.beeswarm}
\alias{ciu.plots.beeswarm}
\title{Create beeswarm-type visualisation.}
\usage{
ciu.plots.beeswarm(data, target.columns = c("Feature", "CI", "Norm.Value"))
}
\arguments{
\item{data}{A \link{data.frame} with CIU (or other) results that has to have
at least the columns:
\itemize{
\item Feature: Feature name.
\item The CI, CU, influence, whatever actual values to plot.
\item Norm.Value: Normalized feature values. This can be omitted.
Such a \link{data.frame} is returned by \link{ciu.explain.long.data.frame}, from which
the "non-relevant" columns have to be removed, however (see examples).
}}

\item{target.columns}{Character vector with names of the columns to use:
\itemize{
\item Column with feature names.
\item Column with actual importance/influence/whatever values to plot.
\item Column with normalized values to use for determining color. If omitted, then
the plot is produced without the colours.
Default: c("Feature", "CI", "Norm.Value").
}}
}
\value{
\code{ggplot} object
}
\description{
Create beeswarm-type visualisation.
}
\examples{
\dontrun{
# Boston data set with GBM model.
library(MASS)
library(caret)
library(ggbeeswarm)
kfoldcv <- trainControl(method="cv", number=10)
gbm <- caret::train(medv ~ ., Boston, method="gbm", trControl=kfoldcv)
ciu <- ciu.new(gbm, medv~., Boston)
df <- ciu.explain.long.data.frame(ciu)
p <- ciu.plots.beeswarm(df); print(p)
p <- ciu.plots.beeswarm(df, c("Feature","CU","Norm.Value")); print(p)
p <- ciu.plots.beeswarm(df, c("Feature","Influence","Norm.Value")); print(p)

# Plot without normalized values.
p <- ciu.plots.beeswarm(df, c("Feature","Influence")); print(p)

# Shapley value-compatible reference value
mean.utility <- (mean(Boston$medv)-min(Boston$medv))/(max(Boston$medv)-min(Boston$medv))
df <- ciu.explain.long.data.frame(ciu, neutral.CU=mean.utility)
p <- ciu.plots.beeswarm(df, c("Feature","Influence","Norm.Value")); print(p)
}
}
