% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{organizations_list_favorites}
\alias{organizations_list_favorites}
\title{List Favorites}
\usage{
organizations_list_favorites(
  object_id = NULL,
  object_type = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{object_id}{integer optional. The id of the object. If specified as a query parameter, must also specify object_type parameter.}

\item{object_type}{string optional. The type of the object that is favorited. Valid options: Container Script, Identity Resolution, Import, Python Script, R Script, dbt Script, JavaScript Script, SQL Script, Template Script, Project, Workflow, Tableau Report, Service Report, HTML Report, SQL Report}

\item{limit}{integer optional. Number of results to return. Defaults to 50. Maximum allowed is 1000.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to created_at. Must be one of: created_at, object_type, object_id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The id of the favorite.}
\item{objectId}{integer, The id of the object. If specified as a query parameter, must also specify object_type parameter.}
\item{objectType}{string, The type of the object that is favorited. Valid options: Container Script, Identity Resolution, Import, Python Script, R Script, dbt Script, JavaScript Script, SQL Script, Template Script, Project, Workflow, Tableau Report, Service Report, HTML Report, SQL Report}
\item{objectName}{string, The name of the object that is favorited.}
\item{createdAt}{string, The time this favorite was created.}
\item{objectUpdatedAt}{string, The time the object that is favorited was last updated}
\item{objectAuthor}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{position}{integer, The rank position of this favorite. Use the patch users/me/favorites/:id/ranking/ endpoints to update.}
}
\description{
List Favorites
}
