% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R, R/clc_category.R, R/clc_raster.R
\name{get_levels.clc}
\alias{get_levels.clc}
\alias{get_levels}
\alias{get_levels.clc_category}
\alias{get_levels.clc_raster}
\title{Retrieve Levels from a CLC Style Definition}
\usage{
\method{get_levels}{clc}(clo)

get_levels(clo)

\method{get_levels}{clc_category}(clo)

\method{get_levels}{clc_raster}(clo)
}
\arguments{
\item{clo}{A CLC object.}
}
\value{
A data frame with columns:
  - `id`: The identifier of the category.
  - `description`: A textual description of the category.
  - `color`: The color associated with the category.
}
\description{
This function extracts the levels values associated with a CLC style definition.
It returns a data frame that contains the fields `id`, `description`, and `color`
from the CLC style definition.
}
\examples{
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

levels <- clo |>
  get_levels()

}
\seealso{
Other CLC class functions: 
\code{\link{as_raster}()},
\code{\link{clc}()},
\code{\link{copy_to}()},
\code{\link{cut_to_extent}()},
\code{\link{get_colors.clc}()},
\code{\link{get_raster}()},
\code{\link{plot_clc}()},
\code{\link{prepare_plot}()},
\code{\link{save_to}()}
}
\concept{CLC class functions}
