% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absLatitudinalMean.R
\name{absLatitudinalMean}
\alias{absLatitudinalMean}
\title{absLatitudinalMean}
\usage{
absLatitudinalMean(rasterForCalculation)
}
\arguments{
\item{rasterForCalculation}{A `SpatRaster` that contains data for plotting according to latitudinal value}
}
\value{
A vector of mean values for each absolute latitude value.
}
\description{
A function to calculate mean values of a `SpatRaster` at the absolute value of latitude,
at the resolution of the given raster layer.
}
\examples{

precipDeviation <- terra::rast(system.file("extdata/precipDeviation.asc",
                                           package = "climateStability"))
precipStability <- 1/precipDeviation
alm <- absLatitudinalMean(rasterForCalculation = precipStability)
plot(alm, main = "Precipitation Stability by Absolute Latitude",
ylab = "Relative Stability", type = "l")

}
\references{
Owens, H.L., Guralnick, R., 2019. climateStability: An R package to estimate
climate stability from time-slice climatologies. Biodiversity Informatics
14, 8–13. https://doi.org/10.17161/bi.v14i0.9786
}
\seealso{
\code{\link{latitudinalMean}} for calculating mean values of rasters for all latitudinal bands.
}
\keyword{manip}
