% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthRateMethods.R
\name{internalLengths}
\alias{internalLengths}
\title{Growth rate estimate using the sum of internal lengths}
\usage{
internalLengths(tree, alpha = 0.05)
}
\arguments{
\item{tree}{An ultrametric tree subset to include only the clone of
interest. Alternatively, a list with several such trees.}

\item{alpha}{Used for calculation of confidence intervals. 1-alpha confidence intervals used with default of alpha = 0.05 (95 percent confidence intervals)}
}
\value{
A dataframe including the net growth rate estimate, the sum of internal lengths and other important details (clone age estimate, runtime, n, etc.)
}
\description{
\code{internalLengths()} provides an estimate for the net growth rate of the clone with confidence bounds, using the internal lengths method.
}
\examples{
internalLengths(cloneRate::exampleUltraTrees[[1]])

}
\seealso{
\code{\link[=maxLikelihood]{maxLikelihood()}}, \code{\link[=sharedMuts]{sharedMuts()}} for other
growth rate methods.
}
