% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthRateMethods.R
\name{maxLikelihood}
\alias{maxLikelihood}
\title{Growth rate estimate using Maximum Likelihood}
\usage{
maxLikelihood(tree, alpha = 0.05)
}
\arguments{
\item{tree}{An ultrametric tree subset to include only the clone of
interest. Alternatively, a list with several such trees.}

\item{alpha}{Used for calculation of confidence intervals. 1-alpha confidence intervals used with default of alpha = 0.05 (95 percent confidence intervals)}
}
\value{
A dataframe including the net growth rate estimate, confidence
intervals, and other important details (clone age estimate, runtime, n, etc.)
}
\description{
Uses the approximation that coalescence times H_i are equal to a+b*U_i to
find a and b. b is equal to 1/r, where r is the net growth rate.
}
\examples{
df <- maxLikelihood(cloneRate::exampleUltraTrees[[1]])

}
\seealso{
\link{internalLengths} which uses an alternatvie method for
growth rate estimation from an ultrametric tree.
}
