% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTrees.R
\name{ultra2mut}
\alias{ultra2mut}
\title{Add poissonian mutations to an ultrametric tree(s)}
\usage{
ultra2mut(tree, nu)
}
\arguments{
\item{tree}{A single tree or list of trees of class "phylo", with edge
lengths in units of time}

\item{nu}{Mutation rate in units of mutations per unit time. Can also be a
vector of mutation rates with length equal to the number of input trees.
Make sure time units are consistent in nu and tree$edge.length}
}
\value{
An ape object of class "phylo" representing the phylogenetic tree
with edge lengths in units of mutations. Value of mutation rate will be
added to 'metadata' data.frame of output tree if such a data.frame exists
in the input tree. Otherwise, mutation rate value will be added to "phylo"
object directly. If input is a list of trees, ultra2mut() will return a
list of such "phylo" objects.
}
\description{
Takes an ultrametric tree of class "phylo" (or a list of such
trees) and draws new edge lengths in units of mutations, with the mean of
each new edge length equal to the old edge length multiplied by the mutation
rate. Mutation rate can be set or drawn from a uniform distribution.
}
\examples{
# Convert the time-based, ultrametric example trees into mutation-based trees
mutTrees <- ultra2mut(exampleUltraTrees,
  nu = stats::runif(n = length(exampleUltraTrees), min = 10, max = 20)
)

}
