% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_transfer.R
\name{cloud_drive_upload}
\alias{cloud_drive_upload}
\title{Upload a local file to Google Drive}
\usage{
cloud_drive_upload(file, root = NULL)
}
\arguments{
\item{file}{Path to a file relative to project folder root. Can contain only
letters, digits, '-', '_', '.', spaces and '/' symbols.}

\item{root}{Google Drive ID or URL of the project root. This serves as the
reference point for all relative paths. When left as \code{NULL}, the root is
automatically derived from the \code{cloudfs.drive} field of the project's
DESCRIPTION file.}
}
\value{
Invisibly returns a \link[googledrive:dribble]{googledrive::dribble} object representing the
uploaded file on Google Drive.
}
\description{
Uploads a local file from the project's directory to its
corresponding location within the project's Google Drive root folder.
}
\details{
Google Drive file structure is different from the usual file
structure like e.g. on Linux or Windows. A folder on Google Drive can have
two or more child folders with the same name. Google Drive marks files and
folders with so-called id values to distinguish between them. These values
are always unique. You can see them in browser URL for example. The concept
of "name" is in the first place for convenience of the end user.

In such a setup a relative file path may correspond to multiple files or
folders. This function however works under assumption that the relative
path you pass to it defines strictly one object. If there's any ambiguity
it throws an error.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a toy csv file
dir.create("toy_data")
write.csv(mtcars, "toy_data/mtcars.csv")

# uploads toy_data/mtcars.csv to 'data' subfolder of project's 
# Google Drive folder
cloud_drive_upload("toy_data/mtcars.csv")

# clean up
unlink("toy_data", recursive = TRUE)
\dontshow{\}) # examplesIf}
}
