% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/significance_functions.R
\name{evaluate_significance_r}
\alias{evaluate_significance_r}
\title{Evaluates the significance of a graph's clusters}
\usage{
evaluate_significance_r(
  g,
  alg_list = list(Louvain = cluster_louvain, `label prop` = cluster_label_prop, walktrap
    = cluster_walktrap),
  no_clustering_coef = FALSE,
  gt_clustering = NULL,
  table_style = "default",
  ignore_degenerate_cl = TRUE,
  Q = 100,
  lower_bound = 0,
  weight_sel = "const_var",
  n_reps = 5,
  w_max = NULL
)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object)}

\item{alg_list}{List of clustering algorithms, which take an \code{igraph} graph as
input and return an object of the \code{communities} class.}

\item{no_clustering_coef}{Logical. If \code{TRUE}, skips the computation of the clustering
coefficient, which is the most computationally costly of the scoring functions.}

\item{gt_clustering}{Vector of integers that correspond to labels of the ground truth clustering. 
The scoring functions will be evaluated on it.}

\item{table_style}{By default returns a table with three columns per algorithm: the original one,
the mean of the corresponding rewired scores (suffix "_r") and it's percentile rank within the
distribution of rewired scores (suffix "_percentile"). If table_style == "string", instead
returns a table with a column per algorithm where each element is of the form "original|rewired(percentile)"}

\item{ignore_degenerate_cl}{Logical. If TRUE, when computing the means of the 
scoring functions, samples with only one cluster will be ignored.
See \link[clustAnalytics]{rewireCpp}.}

\item{Q}{Numeric. Parameter that controls the number of iterations of the switching algorithm,
which will be Q times the order of the graph.}

\item{lower_bound}{Numeric. Lower bound to the edge weights. The randomization
process will avoid steps that would make edge weights fall outside this
bound. It should generally be left as 0 to avoid negative weights.}

\item{weight_sel}{Can be either \code{const_var} or \code{max_weight}.}

\item{n_reps}{Number of samples of the rewired graph.}

\item{w_max}{Numeric. Upper bound for edge weights. The randomization algorithm will avoid steps that would make 
edge weights fall outside this bound. Should be generally left as default (\code{NULL}), unless the network has 
by nature or by construction a known upper bound.}
}
\value{
A matrix with the results of each scoring function and algorithm. See \code{table_style} for details.
}
\description{
Computes community scoring functions to the communities obtained by applying 
the given clustering algorithms to a graph. These are compared to the same scores
for randomized versions of the graph obtained by a switching algorithm that
rewires edges.
}
