% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genInit.R
\name{init.options}
\alias{init.options}
\title{Initialization options with S3 classes}
\usage{
init.options(
  init.method = "hc",
  hc.options = list(modelName = "VVV", use = "SVD"),
  exp.init = list(mahala = TRUE),
  mix.method = "Gower kmeans",
  user.class = integer()
)
}
\arguments{
\item{init.method}{Name of method used to set initial values. If init.method = 'user', must define 'user.class' with a classification vector.}

\item{hc.options}{Model names and use when init.method is 'hc' following conventions of mclust::mclust.options()}

\item{exp.init}{Turn on mahala initialization when expert network}

\item{mix.method}{Initialization methods when data are mixed. Default method when data are Tweedie distributed.}

\item{user.class}{Vector of classification vector set by user and required when init.method = 'user'}
}
\value{
list of initialization specifications
}
\description{
Initialization options with S3 classes
}
\examples{
init.options()
init.options(init.method = "hc")
init.options(init.method = "mixed")
init.options(init.method = "user", user.class = c(1, 1, 2, 1, 3, 3, 1, 2))
}
