% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussint.R
\name{gaussint}
\alias{gaussint}
\alias{gauss.legendre}
\alias{gauss.laguerre}
\alias{gauss.hermite}
\title{Gaussian integration method driver}
\usage{
gaussint(f, x, w)

gauss.legendre(f, m = 5)

gauss.laguerre(f, m = 5)

gauss.hermite(f, m = 5)
}
\arguments{
\item{f}{function to integrate}

\item{x}{list of evaluation points}

\item{w}{list of weights}

\item{m}{number of evaluation points}
}
\value{
the value of the integral
}
\description{
Use the Gaussian method to evaluate integrals
}
\details{
The \code{gaussint} function uses the Gaussian integration to
evaluate an integral.  The function itself is a driver and expects
the integration points and associated weights as options.
}
\examples{
w = c(1, 1)
x = c(-1 / sqrt(3), 1 / sqrt(3))
f <- function(x) { x^3 + x + 1 }
gaussint(f, x, w)

}
\seealso{
Other integration: 
\code{\link{adaptint}()},
\code{\link{giniquintile}()},
\code{\link{mcint}()},
\code{\link{midpt}()},
\code{\link{revolution-solid}},
\code{\link{romberg}()},
\code{\link{simp38}()},
\code{\link{simp}()},
\code{\link{trap}()}
}
\concept{integration}
