% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{Cleanup}
\alias{Cleanup}
\title{Clean up memory by deleting the pointer to the Cmpp instance}
\usage{
Cleanup()
}
\value{
No return value. Called for side effects.
}
\description{
This function is used to clean up and delete the instance of the Cmpp class in
the C++ code. It ensures proper memory management and prevents memory leaks by
deleting the pointer to the \code{Cmpp} object when it is no longer needed.
It is important to call this function after you are done with the \code{Cmpp} object
to ensure that no memory is leaked.
}
\details{
The \code{Cleanup} function must be called after using the \code{Cmpp} object to clean up
the allocated memory in C++. Failure to call this function may result in memory
leaks, as the memory allocated for the \code{Cmpp} object is not automatically freed.
}
\examples{
# Assuming you have previously initialized the Cmpp object with `Initialize()`
Cleanup()
}
