% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pa12_tension}
\alias{pa12_tension}
\title{Example stress-strain data}
\format{
\subsection{\code{pa12_tension}}{

A data frame with 3,212 rows and 3 columns:
\describe{
\item{Coupon}{the coupon ID}
\item{Strain}{the strain measurement \verb{[mm/mm]}}
\item{Stress}{the stress measurement \verb{[MPa]}}
}
}
}
\source{
Alomarah, Amer & Ruan, Dong & Masood, S. & Gao, Zhanyuan. (2019).
Compressive properties of a novel additively manufactured 3D auxetic
structure. Smart Materials and Structures. 28.
10.1088/1361-665X/ab0dd6.
}
\usage{
pa12_tension
}
\description{
Example tension stress-strain data. This data was generated by tracing the
stress-strain graph for PA12 from the manuscript referenced below. The
non-linearity seen at low strain in the original data set was removed, then
the data was re-sampling to produce more tightly spaced strain values.
Normally-distributed error was added to the stress.
The code used to generate the data set can be found at
\url{https://github.com/cmstatr/cmstatrExt/blob/master/data-raw/pa12-tension.R}
}
\keyword{datasets}
