% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{kilauea_iki}
\alias{kilauea_iki}
\title{Chemical Composition of Volcanic Rocks from Kilauea Iki}
\format{
A data frame with 17 observations and 11 variables:
\describe{
  \item{SiO2}{Silicon dioxide (fraction)}
  \item{TiO2}{Titanium dioxide (fraction)}
  \item{Al2O3}{Aluminium oxide (fraction)}
  \item{Fe2O3}{Ferric oxide (fraction)}
  \item{FeO}{Ferrous oxide (fraction)}
  \item{MnO}{Manganese oxide (fraction)}
  \item{MgO}{Magnesium oxide (fraction)}
  \item{CaO}{Calcium oxide (fraction)}
  \item{Na2O}{Sodium oxide (fraction)}
  \item{K2O}{Potassium oxide (fraction)}
  \item{P2O5}{Phosphorus pentoxide (fraction)}
}
}
\source{
Richter, D.H., & Moore, J.G. (1966). Petrology of Kilauea Iki lava lake, Hawaii. *Geological Survey Professional Paper* 537-B.
}
\usage{
kilauea_iki
}
\description{
This dataset contains the chemical composition of volcanic rocks sampled from the lava lake at Kilauea Iki (Hawaii). The data represents major oxide concentrations in fractional form.
}
\details{
The variability in the oxide concentrations is attributed to magnesic olivine fractionation, starting from a single magmatic mass as suggested by Richter & Moore (1966).
}
\keyword{datasets}
