% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelist.R
\name{codelist}
\alias{codelist}
\title{Create a codelist object}
\usage{
codelist(
  codes,
  labels = NULL,
  descriptions = NULL,
  parent = NULL,
  locale = NULL,
  missing = NULL
)
}
\arguments{
\item{codes}{a vector with the codes.}

\item{labels}{optional vector with the labels. Will be converted to character
and should have the same length as \code{codes}. When \code{labels} is not
given \code{as.character(codes)} is used for the labels.}

\item{descriptions}{optional vector with the descriptions of the codes. Will be
converted to character and should have the same length as \code{codes}.}

\item{parent}{optional vector with the parents of the codes. Should be of the
same type and length as \code{codes} and should contain only values present in
\code{codes} or missing values. This can be used to define simple hierarchies.
Codes with NA as their parent are the top-level (level 0) codes in the
hierarchy.}

\item{locale}{optional vector with the locale of the labels, descriptions etc.
of the codes. This should be a character vector with the same length as
\code{codes}. When the code list contains multiple locales each code should be
present in each locale.}

\item{missing}{optional logical vector indicating whether or not the
corresponding code can be treated as a missing value. This can be used to
encode different types of missingness.}
}
\value{
Returns a \code{codelist} object which is a \code{data.frame} with at minimum
the columns 'code' and 'label' and optionally 'description', 'parent',
'locale' and 'missing'. See below for a description of the columns:

\item{code}{The codes. It is expected that these are either characters or
integers although other types are probably supported. For a given locale (see
below) they should be unique. Missing values are not allowed.}

\item{label}{The labels of the codes. These are characters. Missing values
are not allowed.} 

\item{description}{Optional. The description of the codes. These are characters.
Missing values are not allowed.}

\item{missing}{Optional. Logical vector indicating whether or not the
corresponding code can be treated as a special value. This can be used to
have different codes for different types of missingness. Missing values are
not allowed.}

\item{locale}{Optional. Character vector indicating for the given row 
which locale the label and description belong to. The default use is to have
different translations of the labels and descriptions. However, this can also
be used, for example, to specify short and long labels. When there is more
than one locale, there should be multiple lines for each code, one for each
locale.}

\item{parent}{Optional. The parent of the code. This can be used to specify
simple hierarchies. These should be of the same type as the 'code' column and
values should be present in the 'code' column or be 'NA'. When the parent is
'NA' it is assumed this is a top level code. The hierarchy should form a
tree.}

The validity of the code list can be checked using \code{\link{cl_is_valid}}.
}
\description{
Create a codelist object
}
