% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codez.R, R/main.R
\docType{package}
\name{codez}
\alias{codez}
\alias{codez-package}
\title{codez}
\usage{
codez(
  df,
  seq_len = NULL,
  n_windows = 10,
  latent = NULL,
  smoother = FALSE,
  n_samp = 30,
  autoencoder_layers_n = NULL,
  autoencoder_layers_size = NULL,
  autoencoder_activ = NULL,
  forward_net_layers_n = NULL,
  forward_net_layers_size = NULL,
  forward_net_activ = NULL,
  forward_net_reg_L1 = NULL,
  forward_net_reg_L2 = NULL,
  forward_net_drop = NULL,
  loss_metric = "mae",
  autoencoder_optimizer = NULL,
  forward_net_optimizer = NULL,
  epochs = 100,
  patience = 10,
  holdout = 0.5,
  verbose = FALSE,
  ci = 0.8,
  error_scale = "naive",
  error_benchmark = "naive",
  dates = NULL,
  seed = 42
)
}
\arguments{
\item{df}{A data frame with time features on columns. They could be numeric variables or categorical, but not both.}

\item{seq_len}{Positive integer. Time-step number of the forecasting sequence. Default: NULL (random selection within 2 to max preset boundary).}

\item{n_windows}{Positive integer. Number of validation windows to test prediction error. Default: 10.}

\item{latent}{Positive integer. Dimensions of the latent space for encoding-decoding operations. Default: NULL (random selection within preset boundaries)}

\item{smoother}{Logical. Perform optimal smoothing using standard loess for each time feature. Default: FALSE}

\item{n_samp}{Positive integer. Number of samples for random search. Default: 30.}

\item{autoencoder_layers_n}{Positive integer. Number of layers for the encoder-decoder model. Default: NULL (random selection within preset boundaries)}

\item{autoencoder_layers_size}{Positive integer. Numbers of nodes for the encoder-decoder model. Default: NULL (random selection within preset boundaries)}

\item{autoencoder_activ}{String. Activation function to be used by the encoder-decoder model. Implemented functions are: "linear", "relu", "leaky_relu", "selu", "elu", "sigmoid", "tanh", "swish", "gelu". Default: NULL (random selection within standard activations)}

\item{forward_net_layers_n}{Positive integer. Number of layers for the forward net model. Default: NULL (random selection within preset boundaries)}

\item{forward_net_layers_size}{Positive integer. Numbers of nodes for the forward net model. Default: NULL (random selection within preset boundaries)}

\item{forward_net_activ}{String. Activation function to be used by the forward net model. Implemented functions are: "linear", "relu", "leaky_relu", "selu", "elu", "sigmoid", "tanh", "swish", "gelu". Default: NULL (random selection within standard activations)}

\item{forward_net_reg_L1}{Positive numeric between. Weights for L1 regularization. Default: NULL (random selection within preset boundaries).}

\item{forward_net_reg_L2}{Positive numeric between. Weights for L2 regularization. Default: NULL (random selection within preset boundaries).}

\item{forward_net_drop}{Positive numeric between 0 and 1. Value for the dropout parameter for each layer of the forward net model (for example, a neural net with 3 layers may have dropout = c(0, 0.5, 0.3)). Default: NULL (random selection within preset boundaries).}

\item{loss_metric}{String. Loss function for both models. Available metrics: "mse", "mae", "mape". Default: "mae".}

\item{autoencoder_optimizer}{String. Optimization method for autoencoder. Implemented methods are: "adam", "adadelta", "adagrad", "rmsprop", "sgd", "nadam", "adamax". Default: NULL (random selection within standard optimizers).}

\item{forward_net_optimizer}{String. Optimization method for forward net. Implemented methods are: "adam", "adadelta", "adagrad", "rmsprop", "sgd", "nadam", "adamax". Default: NULL (random selection within standard optimizers).}

\item{epochs}{Positive integer. Default: 100.}

\item{patience}{Positive integer. Waiting time (in epochs) before evaluating the overfit performance. Default: 10.}

\item{holdout}{Positive numeric between 0 and 1. Holdout sample for validation. Default: 0.5.}

\item{verbose}{Logical. Default: FALSE.}

\item{ci}{Positive numeric. Confidence interval. Default: 0.8}

\item{error_scale}{String. Scale for the scaled error metrics (for continuous variables). Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics (for continuous variables). Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{dates}{Date. Vector with dates for time features.}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item history: a table with the sampled models, hyper-parameters, validation errors
\item best_model: results for the best selected model according to the weighted average rank, including:
\itemize{
\item predictions: for continuous variables, min, max, q25, q50, q75, quantiles at selected ci, mean, sd, mode, skewness, kurtosis, IQR to range, risk ratio, upside probability and divergence for each point fo predicted sequences; for factor variables, min, max, q25, q50, q75, quantiles at selected ci, proportions, difformity (deviation of proportions normalized over the maximum possible deviation), entropy, upgrade probability and divergence for each point fo predicted sequences
\item testing_errors: testing errors for each time feature for the best selected model (for continuous variables: me, mae, mse, rmsse, mpe, mape, rmae, rrmse, rame, mase, smse, sce, gmrae; for factor variables: czekanowski, tanimoto, cosine, hassebrook, jaccard, dice, canberra, gower, lorentzian, clark)
\item plots: standard plots with confidence interval for each time feature
}
\item time_log
}
}
\description{
Seq2seq Time-Feature Analysis using an Encoder-Decoder to project into latent space and a Forward Network to predict the next sequence.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/codez}
}

}
\author{
\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]


Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
