% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_function.R
\name{reverse_function}
\alias{reverse_function}
\title{The "inverse"/"reverse" Collatz function}
\usage{
reverse_function(n, P = 2, a = 3, b = 1)
}
\arguments{
\item{n}{(numeric|bigz) The value on which
to perform the reverse Collatz function}

\item{P}{(numeric|bigz) Modulus used to divide
n, iff n is equivalent to (0 mod P) Default is 2.}

\item{a}{(numeric|bigz) Factor by which to multiply n. Default is 3.}

\item{b}{(numeric|bigz) Value to add
to the scaled value of n. Default is 1.}
}
\value{
A list of either numeric or bigz type
}
\description{
Calculates the values that would return the input under the Collatz function.
}
\details{
Returns the output of a single application of a Collatz-esque reverse
function. If only one value is returned, it is the value that would be
divided by P. If two values are returned, the first is the value that
would be divided by P, and the second value is that which would undergo
the multiply and add step, regardless of which is larger.
}
\examples{
# Calculates the values that would return the input under the Collatz
# function. Without `gmp` or parameterisation, we can try something
# simple like
reverse_function(1)
reverse_function(2)
reverse_function(4)
# If we want change the default parameterisation we can;
reverse_function(3, -3, -2, -5)
# Or if we only want to change one of them
reverse_function(16, a=5)
# All the above work fine, but the function doesn't offer protection against
# overflowing integers by default. To venture into the world of arbitrary
# integer inputs we can use an `as.bigz` from `gmp`. Compare the two;
reverse_function(99999999999999999999)
reverse_function(as.bigz("99999999999999999999"))
}
