% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_matrix.R
\name{cor_matrix}
\alias{cor_matrix}
\title{Pairwise Correlation Matrix}
\usage{
cor_matrix(df = NULL, predictors = NULL)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}
}
\value{
correlation matrix
}
\description{
If argument 'df' results from \code{\link[=cor_df]{cor_df()}}, transforms it to a correlation matrix. If argument 'df' is a dataframe with predictors, and the argument 'predictors' is provided then \code{\link[=cor_df]{cor_df()}} is used to compute pairwise correlations, and the result is transformed to matrix.

Accepts a parallelization setup via \code{\link[future:plan]{future::plan()}} and a progress bar via \code{\link[progressr:handlers]{progressr::handlers()}} (see examples).
}
\examples{
data(
  vi,
  vi_predictors
)

#reduce size of vi to speed-up example execution
vi <- vi[1:1000, ]

#mixed predictors
vi_predictors <- vi_predictors[1:10]

#parallelization setup
future::plan(
  future::multisession,
  workers = 2 #set to parallelly::availableCores() - 1
)

#progress bar
# progressr::handlers(global = TRUE)

#correlation data frame
df <- cor_df(
  df = vi,
  predictors = vi_predictors
)

df

#correlation matrix
m <- cor_matrix(
  df = df
)

m

#generating it from the original data
m <- cor_matrix(
  df = vi,
  predictors = vi_predictors
)

m

#disable parallelization
future::plan(future::sequential)
}
\seealso{
Other pairwise_correlation: 
\code{\link{cor_clusters}()},
\code{\link{cor_cramer_v}()},
\code{\link{cor_df}()},
\code{\link{cor_select}()}
}
\author{
Blas M. Benito, PhD
}
\concept{pairwise_correlation}
