% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost.R
\name{colocboost}
\alias{colocboost}
\title{ColocBoost: A gradient boosting informed multi-omics xQTL colocalization method}
\source{
See detailed instructions in our tutorial portal: \url{https://statfungen.github.io/colocboost/index.html}
}
\usage{
colocboost(
  X = NULL,
  Y = NULL,
  sumstat = NULL,
  LD = NULL,
  dict_YX = NULL,
  dict_sumstatLD = NULL,
  outcome_names = NULL,
  focal_outcome_idx = NULL,
  focal_outcome_variables = TRUE,
  overlap_variables = FALSE,
  intercept = TRUE,
  standardize = TRUE,
  effect_est = NULL,
  effect_se = NULL,
  effect_n = NULL,
  M = 500,
  stop_thresh = 1e-06,
  tau = 0.01,
  learning_rate_init = 0.01,
  learning_rate_decay = 1,
  dynamic_learning_rate = TRUE,
  prioritize_jkstar = TRUE,
  func_compare = "min_max",
  jk_equiv_corr = 0.8,
  jk_equiv_loglik = 1,
  coloc_thresh = 0.1,
  lambda = 0.5,
  lambda_focal_outcome = 1,
  func_simplex = "LD_z2z",
  func_multi_test = "lfdr",
  stop_null = 1,
  multi_test_max = 1,
  multi_test_thresh = 1,
  ash_prior = "normal",
  p.adjust.methods = "fdr",
  residual_correlation = NULL,
  coverage = 0.95,
  min_cluster_corr = 0.8,
  dedup = TRUE,
  overlap = TRUE,
  n_purity = 100,
  min_abs_corr = 0.5,
  median_abs_corr = NULL,
  median_cos_abs_corr = 0.8,
  tol = 1e-09,
  merge_cos = TRUE,
  sec_coverage_thresh = 0.8,
  weight_fudge_factor = 1.5,
  check_null = 0.1,
  check_null_method = "profile",
  check_null_max = 0.025,
  check_null_max_ucos = 0.015,
  weaker_effect = TRUE,
  LD_free = FALSE,
  output_level = 1
)
}
\arguments{
\item{X}{A list of genotype matrices for different outcomes, or a single matrix if all outcomes share the same genotypes.
Each matrix should have column names, if sample sizes and variables possibly differing across matrices.}

\item{Y}{A list of vectors of outcomes or an N by L matrix if it is considered for the same X and multiple outcomes.}

\item{sumstat}{A list of data.frames of summary statistics.
The columns of data.frame should include either \code{z} or \code{beta}/\code{sebeta}.
\code{n} is the sample size for the summary statistics, it is highly recommendation to provide.
\code{variant} is required if sumstat for different outcomes do not have the same number of variables.
\code{var_y} is the variance of phenotype (default is 1 meaning that the Y is in the \dQuote{standardized} scale).}

\item{LD}{A list of correlation matrix indicating the LD matrix for each genotype. It also could be a single matrix if all sumstats were
obtained from the same genotypes.}

\item{dict_YX}{A L by 2 matrix of dictionary for \code{X} and \code{Y} if there exist subsets of outcomes corresponding to the same X matrix.
The first column should be 1:L for L outcomes. The second column should be the index of \code{X} corresponding to the outcome.
The innovation: do not provide the same matrix in \code{X} to reduce the computational burden.}

\item{dict_sumstatLD}{A L by 2 matrix of dictionary for \code{sumstat} and \code{LD} if there exist subsets of outcomes corresponding to the same sumstat.
The first column should be 1:L for L sumstat The second column should be the index of \code{LD} corresponding to the sumstat.
The innovation: do not provide the same matrix in \code{LD} to reduce the computational burden.}

\item{outcome_names}{The names of outcomes, which has the same order for Y.}

\item{focal_outcome_idx}{The index of the focal outcome if perform GWAS-xQTL ColocBoost}

\item{focal_outcome_variables}{If \code{focal_outcome_variables = TRUE}, only consider the variables exist in the focal outcome.}

\item{overlap_variables}{If \code{overlap_variables = TRUE}, only perform colocalization in the overlapped region.}

\item{intercept}{If \code{intercept = TRUE}, the intercept is fitted. Setting \code{intercept = FALSE} is generally not recommended.}

\item{standardize}{If \code{standardize = TRUE}, standardize the columns of genotype and outcomes to unit variance.}

\item{effect_est}{Matrix of variable regression coefficients (i.e. regression beta values) in the genomic region}

\item{effect_se}{Matrix of standard errors associated with the beta values}

\item{effect_n}{A scalar or a vector of sample sizes for estimating regression coefficients. Highly recommended!}

\item{M}{The maximum number of gradient boosting rounds for each outcome (default is 500).}

\item{stop_thresh}{The stop criterion for overall profile loglikelihood function.}

\item{tau}{The smooth parameter for proximity adaptive smoothing weights for the best update jk-star.}

\item{learning_rate_init}{The minimum learning rate for updating in each iteration.}

\item{learning_rate_decay}{The decayrate for learning rate. If the objective function is large at the early iterations,
we need to have the higher learning rate to improve the computational efficiency.}

\item{dynamic_learning_rate}{If \code{dynamic_learning_rate = TRUE}, the dynamic learning rate based on \code{learning_rate_init} and \code{learning_rate_decay} will be used in SEC.}

\item{prioritize_jkstar}{When \code{prioritize_jkstar = TRUE}, the selected outcomes will prioritize best update j_k^star in SEC.}

\item{func_compare}{The criterion when we update jk-star in SEC (default is "min_max").}

\item{jk_equiv_corr}{The LD cutoff between overall best update jk-star and marginal best update jk-l for lth outcome}

\item{jk_equiv_loglik}{The change of loglikelihood cutoff between overall best update jk-star and marginal best update jk-l for lth outcome}

\item{coloc_thresh}{The cutoff of checking if the best update jk-star is the potential causal variable for outcome l if jk-l is not similar to jk-star (used in Delayed SEC).}

\item{lambda}{The ratio [0,1] for z^2 and z in fun_prior simplex, default is 0.5}

\item{lambda_focal_outcome}{The ratio for z^2 and z in fun_prior simplex for the focal outcome, default is 1}

\item{func_simplex}{The data-driven local association simplex \eqn{\delta} for smoothing the weights. Default is "LD_z2z" is the elastic net for z-score and also weighted by LD.}

\item{func_multi_test}{The alternative method to check the stop criteria. When \code{func_multi_test = "lfdr"}, boosting iterations will be stopped
if the local FDR for all variables are greater than \code{lfsr_max}.}

\item{stop_null}{The cutoff of nominal p-value when \code{func_multi_test = "Z"}.}

\item{multi_test_max}{The cutoff of the smallest FDR for stop criteria when \code{func_multi_test = "lfdr"} or \code{func_multi_test = "lfsr"}.}

\item{multi_test_thresh}{The cutoff of the smallest FDR for pre-filtering the outcomes when \code{func_multi_test = "lfdr"} or \code{func_multi_test = "lfsr"}.}

\item{ash_prior}{The prior distribution for calculating lfsr when \code{func_multi_test = "lfsr"}.}

\item{p.adjust.methods}{The adjusted pvalue method in stats:p.adj  when \code{func_multi_test = "fdr"}}

\item{residual_correlation}{The residual correlation based on the sample overlap, it is diagonal if it is NULL.}

\item{coverage}{A number between 0 and 1 specifying the \dQuote{coverage} of the estimated colocalization confidence sets (CoS) (default is 0.95).}

\item{min_cluster_corr}{The small correlation for the weights distributions across different iterations to be decided having only one cluster.}

\item{dedup}{If \code{dedup = TRUE}, the duplicate confidence sets will be removed in the post-processing.}

\item{overlap}{If \code{overlap = TRUE}, the overlapped confidence sets will be removed in the post-processing.}

\item{n_purity}{The maximum number of confidence set (CS) variables used in calculating the correlation (\dQuote{purity}) statistics.
When the number of variables included in the CS is greater than this number, the CS variables are randomly subsampled.}

\item{min_abs_corr}{Minimum absolute correlation allowed in a confidence set. The default is 0.5 corresponding to a squared correlation of 0.25,
which is a commonly used threshold for genotype data in genetic studies.}

\item{median_abs_corr}{An alternative "purity" threshold for the CS. Median correlation between pairs of variables in a CS less than this
threshold will be filtered out and not reported. When both min_abs_corr and median_abs_corr are set,
a CS will only be removed if it fails both filters. Default set to NULL but it is recommended to set it to 0.8 in practice.}

\item{median_cos_abs_corr}{Median absolute correlation between variants allowed to merge multiple colocalized sets. The default is 0.8 corresponding to a stringent threshold
to merge colocalized sets, which may resulting in a huge set.}

\item{tol}{A small, non-negative number specifying the convergence tolerance for checking the overlap of the variables in different sets.}

\item{merge_cos}{When \code{merge_cos = TRUE}, the sets for only one outcome will be merged if passed the \code{median_cos_abs_corr}.}

\item{sec_coverage_thresh}{A number between 0 and 1 specifying the weight in each SEC (default is 0.8).}

\item{weight_fudge_factor}{The strength to integrate weight from different outcomes, default is 1.5}

\item{check_null}{The cut off value for change conditional objective function. Default is 0.1.}

\item{check_null_method}{The metric to check the null sets. Default is "profile"}

\item{check_null_max}{The smallest value of change of profile loglikelihood for each outcome in CoS.}

\item{check_null_max_ucos}{The smallest value of change of profile loglikelihood for each outcome in uCoS.}

\item{weaker_effect}{If \code{weaker_effect = TRUE}, consider the weaker single effect due to coupling effects}

\item{LD_free}{When \code{LD_free = FALSE}, objective function doesn't include LD information.}

\item{output_level}{When \code{output_level = 1}, return basic cos details for colocalization results
When \code{output_level = 2}, return the ucos details for the single specific effects.
When \code{output_level = 3}, return the entire Colocboost model to diagnostic results (more space).}
}
\value{
A \code{"colocboost"} object with some or all of the following elements:

\item{cos_summary}{A summary table for colocalization events.}
\item{vcp}{The variable colocalized probability for each variable.}
\item{cos_details}{A object with all information for colocalization results.}
\item{data_info}{A object with detailed information from input data}
\item{model_info}{A object with detailed information for colocboost model}
\item{ucos_details}{A object with all information for trait-specific effects when \code{output_level = 2}.}
\item{diagnositci_details}{A object with diagnostic details for ColocBoost model when \code{output_level = 3}.}
}
\description{
\code{colocboost} implements a proximity adaptive smoothing gradient boosting approach for multi-trait colocalization at gene loci,
accommodating multiple causal variants. This method, introduced by Cao etc. (2025), is particularly suited for scaling
to large datasets involving numerous molecular quantitative traits and disease traits.
In brief, this function fits a multiple linear regression model \eqn{Y = XB + E} in matrix form.
ColocBoost can be generally used in multi-task variable selection regression problem.
}
\details{
The function \code{colocboost} implements the proximity smoothed gradient boosting method from Cao etc (2025).
There is an additional step to help merge the confidence sets with small \code{between_putiry}
(default is 0.8) but within the same locus. This step addresses potential instabilities in linkage disequilibrium (LD) estimation
that may arise from small sample sizes or discrepancies in minor allele frequencies (MAF) across different confidence sets.
}
\examples{
# colocboost example
set.seed(1)
N <- 1000
P <- 100
# Generate X with LD structure
sigma <- 0.9^abs(outer(1:P, 1:P, "-"))
X <- MASS::mvrnorm(N, rep(0, P), sigma)
colnames(X) <- paste0("SNP", 1:P)
L <- 3
true_beta <- matrix(0, P, L)
true_beta[10, 1] <- 0.5 # SNP10 affects trait 1
true_beta[10, 2] <- 0.4 # SNP10 also affects trait 2 (colocalized)
true_beta[50, 2] <- 0.3 # SNP50 only affects trait 2
true_beta[80, 3] <- 0.6 # SNP80 only affects trait 3
Y <- matrix(0, N, L)
for (l in 1:L) {
  Y[, l] <- X \%*\% true_beta[, l] + rnorm(N, 0, 1)
}
res <- colocboost(X = X, Y = Y)
res$cos_details$cos$cos_index

}
\concept{colocboost}
