% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorDF-package.R
\name{colorDF-global-options}
\alias{colorDF-global-options}
\alias{colorDF_options}
\title{Global options for colorDF}
\usage{
colorDF_options()
}
\description{
The behavior of colorful data frames can be influenced by a number of
global options set with \code{\link[=options]{options()}}. All options and their defaults can be viewed with
\code{colorDF_options()}.
}
\details{
The following global options are interpreted by functions in the colorDF
package:
\itemize{
\item \code{colorDF_n} (default: \code{20}): how many rows at maximum are printed (set to
\code{Inf} to always show all rows).
\item \code{colorDF_theme} (default: \code{"light"}): theme assigned by default to the new
objects by \code{\link[=colorDF]{colorDF()}} (and also when passing a data frame directly to
\code{\link[=summary_colorDF]{summary_colorDF()}}).
\item \code{colorDF_tibble_style} (default: \code{FALSE}): if \code{TRUE}, then only column
will be shown which fit on the screen (much like in the default print method
for \link[tibble:tibble]{tibbles}.
\item \code{colorDF_noitalic} (default: \code{FALSE}): some terminals do not support
italics and instead use video inverse. This will make some styles look
really weird. If this option is set to \code{TRUE} at time that the colorDF
package is loaded, then the italic style will be silently ignored.
Changing this option will have no effect when set after the package is loaded,
so best put it in your \code{.Rprofile}.
\item \code{colorDF_sep}: separator for the table columns
\item \code{width}: width of the terminal in characters
}
}
\examples{
## use the dark theme for a terminal with dark background
options(colorDF_theme="dark")
colorDF(mtcars)
}
\seealso{
\code{\link[=colorDF]{colorDF()}} on creating colorful data frames;
\code{\link[=df_style]{df_style()}} on how to modify style of the colorful data frame;
\code{\link[=colorDF_themes]{colorDF_themes()}} to list all themes; \code{\link[=colorDF_themes_show]{colorDF_themes_show()}}
to view all themes.
}
