% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_miscellaneous.R
\name{exportTree}
\alias{exportTree}
\title{Export a distance matrix as a tree object}
\usage{
exportTree(getColorDistanceMatrixObject, file, return.tree = FALSE)
}
\arguments{
\item{getColorDistanceMatrixObject}{A distance matrix, especially as returned
by \code{\link{getColorDistanceMatrix}}, but any numeric symmetrical matrix
will work.}

\item{file}{Character vector of desired filename for saving tree. Should end
in ".newick".}

\item{return.tree}{Logical. Should the tree object be returned to the working
environment in addition to being saved as a file?}
}
\value{
Newick tree saved in specified location and \code{as.phylo} tree
  object if \code{return.tree=TRUE}.
}
\description{
Converts a symmetrical distance matrix to a tree and saves it in newick
format. Uses \code{\link[stats]{hclust}} to form clusters.
}
\examples{
\dontrun{
clusterList <- colordistance::getHistList(dir(system.file("extdata",
"Heliconius/", package="colordistance"), full.names=TRUE), lower=rep(0.8, 3),
upper=rep(1, 3))
CDM <- colordistance::getColorDistanceMatrix(clusterList, method="emd",
plotting=FALSE)

# Tree is both saved in current working directory and stored in
# heliconius_tree variable

heliconius_tree <- colordistance::exportTree(CDM,
"./HeliconiusColorTree.newick", return.tree=TRUE)}
}
