% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01b_remove_background.R
\name{removeBackground}
\alias{removeBackground}
\title{Remove background pixels in image}
\usage{
removeBackground(
  img,
  lower = NULL,
  upper = NULL,
  quietly = FALSE,
  alpha.channel = TRUE
)
}
\arguments{
\item{img}{Image array, either output from \code{\link[png]{readPNG}} or
\code{\link{jpeg}{readJPEG}}.}

\item{lower, upper}{RGB or HSV triplets specifying the bounds for background
pixels. See \code{\link{loadImage}}.}

\item{quietly}{Logical. Display a message if using transparency?}

\item{alpha.channel}{Logical. If available, should alpha channel transparency be
used to mask background? See details.}
}
\value{
A list with a 3-dimensional RGB array and a 2-dimensional array of
  non-background pixels with R, G, B columns.
}
\description{
Take an image array (from \code{\link[png]{readPNG}} or
\code{\link{jpeg}{readJPEG}}) and remove the background pixels based on
transparency (if a PNG with transparency) or color boundaries.
}
\details{
If \code{alpha.channel = TRUE}, transparency takes precedence over
  color masking. If you provide a PNG with any pixels with alpha < 1,
  \code{removeBackground} ignores any \code{lower} and \code{upper} color
  boundaries and assumes transparent pixels are background. If all pixels are
  opaque (alpha = 1), color masking will apply.
}
\examples{

# remove background by transparency
img_path <- system.file("extdata/chrysochroa_NPL.png",
 package = "colordistance")
 
img_array <- png::readPNG(img_path)

img_filtered <- removeBackground(img_array)

# remove background by color
img_path <- dir(system.file("extdata/Heliconius", 
package = "colordistance"), 
recursive = TRUE, full.names = TRUE)[1]

img_array <- jpeg::readJPEG(img_path)

img_filtered <- removeBackground(img_array,
lower = rep(0.8, 3), upper = rep(1, 3))

}
