% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/color_plane.R
\name{blend_colors}
\alias{blend_colors}
\alias{blend_colors,ColorPlane,ColorPlane,numeric-method}
\alias{blend_colors,ColorPlane,ColorPlane,missing-method}
\alias{blend_colors,HexColorPlane,RGBColorPlane,numeric-method}
\alias{blend_colors,HexColorPlane,ConstantColorPlane,numeric-method}
\title{blend two color planes}
\usage{
blend_colors(bottom, top, alpha)

\S4method{blend_colors}{ColorPlane,ColorPlane,numeric}(bottom, top, alpha = 1)

\S4method{blend_colors}{ColorPlane,ColorPlane,missing}(bottom, top)

\S4method{blend_colors}{HexColorPlane,RGBColorPlane,numeric}(bottom, top, alpha)

\S4method{blend_colors}{HexColorPlane,ConstantColorPlane,numeric}(bottom, top, alpha = 1)
}
\arguments{
\item{bottom}{the bottom color plane}

\item{top}{the top color plane}

\item{alpha}{the alpha overlay value.}
}
\value{
a new \code{\linkS4class{ColorPlane}} instance with `top` and `bottom` alpha-blended.
}
\description{
given two color planes, generate a new color plane by blending the colors using the supplied alpha multiplier.
}
\details{
The functions in this package blend colors based on the "over" operator where `top` if foreground and `bottom` is background.
}
\examples{

top <- IntensityColorPlane(1:5, cols=rainbow(5))
bottom <- IntensityColorPlane(1:5, cols=rev(rainbow(5)))

top <- map_colors(top)
bottom <- map_colors(bottom)
bc <- blend_colors(bottom, top, .5)
}
\references{
https://en.wikipedia.org/wiki/Alpha_compositing
}
