% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMRTglobe.r
\name{calcMRTglobe}
\alias{calcMRTglobe}
\title{MRT calculation based on standard and mixed convection}
\usage{
calcMRTglobe(tg, ta, vel, x = 0.15)
}
\arguments{
\item{tg}{- a numeric value presenting globe temperature in [degree C]}

\item{ta}{- a numeric value presenting air temperature in [degree C]}

\item{vel}{- a numeric value presenting air velocity in [m/s]}

\item{x}{- a numeric value presenting globe diameter in [m]}
}
\value{
\code{calcMRTglobe} MRT with standard and mixed correction
}
\description{
\code{calcMRTglobe} calculates the mean radiant temperature considering mixed convection
}
\details{
aliases MRT globe

This model has only been validated from x = 0.040m (ping pong ball) to

x = 0.150m (standard globe thermometer) globes
}
\examples{
#Globe temperature [C]
tg <- 30
#Air temperature [C]
ta <- 24
#Air speed [m/s]
vel <- 0.0
calcMRTglobe(tg, ta, vel)
}
\references{
Teitelbaum et al. (2022) <10.1038/s41598-022-10172-5>
Teitelbaum (2022)  <https://github.com/eteitelb/MixedConvection>
}
\author{
code implemented into R by Shaomi Rahman and Marcel Schweiker.
}
