% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.calibrate.get.model.R
\name{logistic.calibrate.get.model}
\alias{logistic.calibrate.get.model}
\title{Compute and returns the logistic regression for a dataset}
\usage{
logistic.calibrate.get.model(LR.ss, LR.ds)
}
\arguments{
\item{LR.ss}{a vector of likelihood ratios for the comparisons of items known
to be from the same source}

\item{LR.ds}{a vector of likelihood ratios for the comparisons of items known
to be from different sources}
}
\value{
a \code{list} with multiple items: \describe{
\item{coefficients}{coefficients of the fitted model}
\item{prior.odds}{prior odds for the input data}
}
}
\description{
Compute and returns the logistic regression for a dataset
}
\examples{
# the list of LRs for the same source proposition
LR.same = c(0.5, 2, 4, 6, 8, 10)
# the list of LRs for the different source proposition
LR.different = c(0.2, 0.4, 0.6, 0.8, 1.1)
# compute the logistic calibration on the data
logistic.calibrate.get.model(LR.same, LR.different) 

}
\seealso{
\code{\link[=logistic.apply.calibration]{logistic.apply.calibration()}}
}
\author{
Marco De Donno
}
