% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian.competition.kernel.R
\name{Gaussian.competition.kernel}
\alias{Gaussian.competition.kernel}
\title{Gaussian competition kernel}
\usage{
Gaussian.competition.kernel(
  trait.values,
  trait.compet = "trait.b",
  sigma.b = 0.03,
  ...
)
}
\arguments{
\item{trait.values}{Dataframe of all traits}

\item{trait.compet}{Name of trait related to resource use}

\item{sigma.b}{Width of Gaussian kernel}

\item{...}{Any additional parameters}
}
\description{
It calculates pairwise competition coefficients as overlap of Gaussian resource utilization curve
}
\details{
It assumes that each species has Gaussian resource utilization curve:
\deqn{\exp(\frac{(x-trait.value)^2}{sigma.b})}{exp([(x-trait.value)^2]/(sigma.b/2))}
where:      x = quality of resource (e.g. seed size or rooting depth\cr

Optima of curves depend on trait value related to resource use,
while standard deviation is the same for all species (note that for technical reason
parameter \code{sigma.b} is twice of the common sqared s.d.).
Pairwise competition coefficients are calculated as overlap of
resource utilization functions (MacArthur & Levins 1967).See details in
\code{vignette("competition")}
}
\references{
MacArthur R, Levins R (1967) The Limiting Similarity,
Convergence, and Divergence of Coexisting Species.
\emph{The American Naturalist} \bold{101}: 377-385.
\doi{10.1086/282505}
}
\seealso{
\code{\link{competition.kernel}}
}
