% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait.sampling.R
\name{trait.sampling}
\alias{trait.sampling}
\title{Simulated sampling for trait value measurement}
\usage{
trait.sampling(x, ITV = FALSE, aggregate = TRUE, n = 5)
}
\arguments{
\item{x}{community and trait data matrix produced by \code{\link{comm.simul}}
function}

\item{ITV}{If \code{TRUE} each subcommunity are sampled separately, otherwise
the meta-community level sampling was done}

\item{aggregate}{If \code{TRUE} mean trait values are returned, otherwise the raw values
of sampled individuals}

\item{n}{Number of sampled individuals}
}
\value{
data.frame with fields: \code{species}, \code{site} (only if \code{ITV=TRUE}),
       \code{trait.a}, \code{trait.b}, \code{trait.c} (raw values or means depending on parameter \code{aggregate})
}
\description{
Randomly selects individuals for trait value measurement and gives back raw measured
traits or their means
}
\details{
It simulates the real world situation that not all individuals are collected for trait measurement.
If \code{ITV==FALSE}, all individuals belonging to the species are pooled, and then \code{n}
randomly selected individuals are measured. If \code{ITV==TRUE}, \code{n} individuals are
measured in each (sub)community, where the species occur. If the occurring individuals are
less than \code{n}, all individuals are measured.

If \code{aggregate==TRUE}, meta-community or subcommunity level means are calculated, otherwise
raw measurements are returned.
}
\examples{
x<-comm.simul(S=20, J=30)
str(x)

w<-trait.sampling(x$final.community)
w

w<-trait.sampling(x$final.community,ITV=TRUE,aggregate=TRUE)
str(w)


}
