% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequ.R
\name{concstats_inequ}
\alias{concstats_inequ}
\title{Inequality and Diversity Measures}
\usage{
concstats_inequ(x, normalized = FALSE, type = c("entropy", "gini",
 "simpson", "palma", "grs", "all"), na.rm = TRUE, digits = NULL)
}
\arguments{
\item{x}{A non-negative numeric vector.}

\item{normalized}{Logical. Argument of the functions
\code{concstats_entropy}, \code{concstats_gini} specifying whether or not a
normalized value is required. Ranges from (0, 1) and often used for
comparison over time. Must be either \code{TRUE} or \code{FALSE}. The
default is \code{FALSE}.}

\item{type}{A character string of the measure to be calculated, defaults to
\code{concstats_entropy}. Input is not case-sensitive.}

\item{na.rm}{A logical vector that indicates whether \code{NA} values should
be excluded or not. If set to \code{FALSE} the computation yields \code{NA}
if vector contains \code{NA} values.
Must be either \code{TRUE} or \code{FALSE}. The default is \code{TRUE}.}

\item{digits}{A non-null value for digits specifies the minimum number of
significant digits to be printed in values. The default is \code{NULL} and
will use base R print option. Significant digits defaults to 7.}
}
\value{
The calculated numeric measure or a \verb{data frame}
}
\description{
A set of different inequality and diversity measures.
}
\details{
\code{concstats_inequ} is a wrapper for the proposed inequality measures
\code{\link[=concstats_entropy]{concstats_entropy()}}, \code{\link[=concstats_gini]{concstats_gini()}},\code{\link[=concstats_simpson]{concstats_simpson()}},
\code{\link[=concstats_palma]{concstats_palma()}},\code{\link[=concstats_grs]{concstats_grs()}}, \code{\link[=concstats_all_inequ]{concstats_all_inequ()}}
If no measure is specified, \code{concstats_entropy} is the default.
\code{concstats_entropy} returns the Shannon Entropy (Shannon, 1948),
\code{concstats_gini} is the Gini coefficient. You can normalize the
Entropy and Gini measures by setting \code{normalized = TRUE}
\code{concstats_palma} measures the ratio of inequality (normally used in
the context of measuring income inequality) of the top 10 percent to the
bottom 40 percent (Palma, 2006).
\code{concstats_grs} is an alternative inequality measure (Ginevicius, 2009)
and
\code{concstats_all_inequ} returns all measures in a one step procedure.
For more details or references please see the help page of the respective
function.
}
\examples{
# a vector of market shares
x <- c(0.4, 0.2, 0.25, 0.1, 0.05)
# Calculate the Palma ratio
concstats_inequ(x, type = "palma")
# Calculate the entropy measure directly
concstats_entropy(x, normalized = TRUE)
# Calculate the group measures
concstats_inequ(x, type = "all", digits = 2)

}
\seealso{
\code{\link[=concstats_concstats]{concstats_concstats()}},\code{\link[=concstats_mstruct]{concstats_mstruct()}},\code{\link[=concstats_comp]{concstats_comp()}}
}
