% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\encoding{UTF-8}
\name{jobchar}
\alias{jobchar}
\title{Meta-analytic correlations of job characteristics with performance and satisfaction}
\format{
list with entries \code{r} (mean observed correlations), \code{rho} (mean
corrected correlations), \code{n} (sample sizes), \code{sevar_r} (sampling error
variances for mean observed correlations), \code{sevar_rho} (sampling error
variances for mean corrected correlations), and \code{source} (character labels
indicating which meta-analytic correlations came from the same source)
}
\usage{
data(jobchar)
}
\description{
Self-rated job characteristics intercorrelations and correlations with
other-rated job performance and self-rated job satisfaction from Humphrey et
al. (2007).
}
\examples{
data(jobchar)
predictors <- c('auto', 'skill_var', 'task_var', 'task_sig', 'task_id',
                'fb_job', 'job_comp', 'interdep', 'fb_others', 'soc_support')
sevar_jobchar_perf <-
  cor_covariance_meta(
    r = jobchar$r[c('perform', predictors), c('perform', predictors)],
                    n = jobchar$n[c('perform', predictors), c('perform', predictors)],
                    sevar = jobchar$sevar_r[c('perform', predictors), c('perform', predictors)],
                    rho = jobchar$rho[c('perform', predictors), c('perform', predictors)],
                    sevar_rho = jobchar$sevar_rho[c('perform', predictors),
                                                  c('perform', predictors)],
                    source = jobchar$source[c('perform', predictors), c('perform', predictors)])
cpa_jobchar_perf <- cpa_mat(perform ~ auto + skill_var + task_var + task_sig +
                              task_id + fb_job + job_comp +
                              interdep + fb_others + soc_support,
                            cov_mat = jobchar$rho,
                            n = harmonic_mean(as.vector(jobchar$n[c('perform', predictors),
                                                                  c('perform', predictors)])),
                            se_var_mat = sevar_jobchar_perf,
                            adjust = "pop", conf_level = .95)
}
\references{
Humphrey, S. E., Nahrgang, J. D., & Morgeson, F. P. (2007).
Integrating motivational, social, and contextual work design features: A meta-analytic summary and theoretical extension of the work design literature.
\emph{Journal of Applied Psychology, 92}(5), 1332–1356. \doi{10.1037/0021-9010.92.5.1332}
}
\keyword{datasets}
