% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error_cpa.R
\name{n_effective_R2}
\alias{n_effective_R2}
\title{Effective sample size}
\usage{
n_effective_R2(R2, var_R2, p)
}
\arguments{
\item{R2}{Observed \emph{R}^2^ value}

\item{var_R2}{Estimated sampling error variance for \emph{R}^2^}

\item{p}{Number of predictors in the regression model}
}
\value{
An effective sample size.
}
\description{
Estimate an effective sample size for a statistic given the observed statistic
and the estimated sampling error variance (cf. Revelle et al., 2017).
}
\details{
\code{n_effective_R2} estimates the effective sample size for the \emph{R}^2^ value from
an OLS regression model, using the sampling error variance formula from Cohen
et al. (2003).
}
\examples{
n_effective_R2(0.3953882, 0.0005397923, 5)
}
\references{
Revelle, W., Condon, D. M., Wilt, J., French, J. A., Brown, A., & Elleman, L. G. (2017).
Web- and phone-based data collection using planned missing designs.
In N. G. Fielding, R. M. Lee, & G. Blank, \emph{The SAGE Handbook of Online Research Methods} (pp. 578–594).
SAGE Publications. \doi{10.4135/9781473957992.n33}

Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003).
\emph{Applied multiple regression/correlation analysis for the behavioral sciences} (3rd ed.).
Routledge. \doi{10.4324/9780203774441}
}
