% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_region_canvas}
\alias{plot_region_canvas}
\title{Plot a canvas backed with regions defined by a set of boundaries}
\usage{
plot_region_canvas(boundaries, extra_boundaries = NULL, values,
  interpretations = NULL, boundary_values = FALSE,
  boundary_label_pos = "below", interpretation_label_pos = "right",
  x_axis_pos = "none", y_axis_pos = "none", inner_margin = c(0, 0.05, 0,
  0.05), edge_margin = c(0, 0.02, 0, 0.02), edge_type = "gradient", ...)
}
\arguments{
\item{boundaries}{Named vector of numerical values of where boundaries should be drawn.}

\item{extra_boundaries}{Names optional.}

\item{values}{A matrix with either one or two columns containing the values of
point estimates (one column) or ranges (two columns). Row names
can specify labels.}

\item{interpretations}{Character vector of interpretations to be used for labelling interpretations
or \code{NULL}. If provided, should be the same length as
\code{nrow(values)}.}

\item{boundary_values}{A logical value indicating whether the values should be appended to
the boundaries' names.}

\item{boundary_label_pos}{Where to put the boundary labels.
Options are \code{c("below", "above", "on top", "none")}.
If you are planning to plot values on the canvas and want the boundary
labels on top then you may want to choose "none" and make a call to
\code{label_ontop_boundaries()} after plotting values.}

\item{interpretation_label_pos}{Options are \code{c("right", "left", "none")}}

\item{x_axis_pos}{Location of a numerical x axis.
Options are \code{c("none", "below", "above")}.}

\item{y_axis_pos}{Location of a numerical y axis. Default "none" will almost always be right.
Options are c\code{("none", "left", "right")}.}

\item{inner_margin}{Numerical vector of the form \code{c(bottom, left, top, right)}, which
gives the amount of inner margin to be added, expressed as a proportion
of the plotted area. This is space designed to be past any plotted objects
but before the edging (defined separately via \code{edge_margin}).
See Details.}

\item{edge_margin}{Numerical vector of the form \code{c(bottom, left, top, right)}, which gives
the amount of 'edge margin' to be added, expressed as a proportion of the
plotted width. This is the space designed to be occupied by plot edges
(e.g. a gradient fading out). Currently only implemented for left and
right; top and bottom values are ignored. See Details.}

\item{edge_type}{What style of edge to draw at the sides of the plot. Currently supported
options are \code{"gradient"} (the default) and \code{"zigzag"}.}

\item{...}{Further parameters to be passed on.}
}
\description{
Produces a plot with all the background elements for plotting
interpretation_set objects and similar outputs.
}
\details{
If using to plot interpretation_set objects as generic items, the
boundaries will typically be at arbitrary values selected for
visual clarity. In this case it will typically not make sense to
plot a numerical x axis. But boundaries can also be plotted as specific
values related to the intended interpretation, and x axis plotting is
normally appropriate in this case.

The colours of the background regions are determined by
graphics::palette. Normally it will use the first n colours from the
palette, where n is the number of regions (which is the number of
boundaries + 1). If the left-most boundary is set to be at the edge of
the plot (by having no values lower than it and setting inner_margin[2]
and edge_margin[2] to 0), then the first colour in palette will be unused.
Similarly, if the right-most boundary is set to be the edge of the plot
then there will only be as many regions as boundaries, and elements 1:n-1
of the palette will be used. (And similarly, one fewer regions than
boundaries will be drawn if both the first and last boundaries are
the edges of the plot.)

A pair of extra margins are defined for the purposes of this plot. Both
are technically drawn as part of the plotting area (i.e., not in the area
of the actual margin, which normally contains axes etc.).
Note that the order of edges used in these margins is the same as the
\code{graphics::par} parameters \code{mar} and \code{oma}, but the
scaling / units are not. These parameters are specified proportional to
the area of active plotting, rather than as lines.)
}
