% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_indicator_EUS.R
\name{download_indicator_EUS}
\alias{download_indicator_EUS}
\title{Download  a dataset (tibble) from Eurostat.}
\usage{
download_indicator_EUS(
  indicator_code,
  fromTime,
  toTime,
  gender = c(NA, "T", "F", "M")[1],
  ageInterv = NA,
  countries = c("BE", "DK", "FR", "DE", "EL", "IE", "IT", "LU", "NL", "PT", "ES", "AT",
    "FI", "SE", "CY", "CZ", "EE", "HU", "LV", "LT", "MT", "PL", "SK", "SI", "BG", "RO",
    "HR"),
  rawDump = FALSE,
  uniqueIdentif = 1
)
}
\arguments{
\item{indicator_code}{the variable describing countries, chosen within
the collection   convergEU_glb()$metaEUStat$selectorUser.}

\item{fromTime}{first year to be considered.}

\item{toTime}{last year to be considered.}

\item{gender}{which gender, one of  c("T","F","M") for Total, Females, Males.}

\item{ageInterv}{a string of character representing the age class to
be considered as coded by Eurostat, for example 'Y15-74'.}

\item{countries}{a collection of strings representing countries
in the standard two letters format; the most important
sets are stored as a  global function
convergEU_glb(), for example convergEU_glb()$EU27;
if countries = NA, then all available countries are
downloaded.}

\item{rawDump}{if TRUE raw downloaded data are returned, otherwise
filtered values are provided.}

\item{uniqueIdentif}{identifiers of further conditional variables (1,2,...).}
}
\value{
a dataset (tibble) years by countries, possibly conditioned
         to gender, within the  list  as  component named res.
         If rawDump is TRUE then bulk data are provided. The list component
         msg may contain auxiliary information on conditioning variables.
}
\description{
From the Eurostat web site, a dataset is created whose structure is
years by countries, possibly conditioned to  gender, age class and other
variables.
}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
