% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impu_det_lin.R
\name{impu_det_lin}
\alias{impu_det_lin}
\title{Imputation of  missing values}
\usage{
impu_det_lin(timeIni, timeEnd, timeDelta, indicIni, indicFin)
}
\arguments{
\item{timeIni}{starting time}

\item{timeEnd}{ending time}

\item{timeDelta}{collection of times where missing values are located}

\item{indicIni}{observed value at timeIni}

\item{indicFin}{observed value at timeEnd}
}
\value{
imputed tibble with   an indicator of missingness (wasMissing).
}
\description{
Imputation is deterministic and based on a straight line between two
points.
}
\examples{

# Example 1
# Simplest Imputation of one missing value between two observed values:
res1 <- impu_det_lin(timeIni= 88,
    timeEnd = 90,
    timeDelta = 89,
    indicIni = 120,
    indicFin = 100)

# Example 2
# Multiple Imputation of  missing values:
    res2 <-impu_det_lin(timeIni= 90,
    timeEnd = 93,
    timeDelta=c(91,92),
    indicIni = 100,
    indicFin = 108)

# Multiple Imputation of  missing values with delta > 1:
res3 <- impu_det_lin(timeIni= 2000,
    timeEnd = 2015,
    timeDelta=seq(2005,2010,5),
    indicIni = 100,
    indicFin = 108)



}
\references{
{\url{https://www.eurofound.europa.eu/system/files/2022-04/introduction-to-the-convergeu-package-0.6.4-tutorial-v2-apr2022.pdf}}
}
