% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence_utilities.R
\name{plot_sim_multi}
\alias{plot_sim_multi}
\title{Plot Multiple Similarity Measures}
\usage{
plot_sim_multi(similarities, titles)
}
\arguments{
\item{similarities}{A list of similarity measures for a single dyad}

\item{titles}{A character vector of titles for each similarity measure}
}
\value{
A ggplot object
}
\description{
Plot multiple similarity measures for a single dyad
}
\details{
This function creates a faceted plot of multiple similarity measures for a single dyad.
}
\examples{
sim1 <- list(sequence = c(0.5, 0.6, 0.7, 0.6, 0.8), average = 0.64)
sim2 <- list(sequence = c(0.4, 0.5, 0.6, 0.7, 0.7), average = 0.58)
similarities <- list(sim1, sim2)
titles <- c("Measure 1", "Measure 2")

# Plot multiple similarity measures
plot <- plot_sim_multi(similarities, titles)
print(plot)
}
