% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benford.R
\name{corona_converge}
\alias{corona_converge}
\title{Create various statistical distributions}
\usage{
corona_converge(
  n = 1e+05,
  method = "add",
  runs = 7,
  pdf = FALSE,
  xscale = 1,
  bins = 64,
  log = FALSE
)
}
\arguments{
\item{n}{is the number of samples}

\item{method}{is either 'multiply' or 'add'}

\item{runs}{number of iterations (default 7)}

\item{pdf}{defaults to FALSE}

\item{xscale}{a scaling factor, can use values < 1.0 to magnify (x) e.g. 0.4}

\item{bins}{defaults to 64}

\item{log}{take logarithm of values (for 'multiply')}
}
\description{
Build a normal or log-normal distribution from simple components.
Large numbers e.g. n=1e6 will take some time to run.
}
\examples{
corona_converge( n=10000, method='multiply', xscale=0.4, bins=128, runs=5 )
}
\keyword{Benford}
\keyword{central}
\keyword{corona}
\keyword{law}
\keyword{limit}
\keyword{log-normal}
\keyword{lognormal}
\keyword{normal}
\keyword{theorem}
