% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{a_j}
\alias{a_j}
\title{Inverse rounding function}
\usage{
a_j(j, y_max = Inf)
}
\arguments{
\item{j}{the integer-valued input(s)}

\item{y_max}{a fixed and known upper bound for all observations; default is \code{Inf}}
}
\value{
The (lower) interval endpoint(s) associated with \code{j}.
}
\description{
Define the intervals associated with \code{y = j} based on the flooring function.
The function returns \code{-Inf} for \code{j = 0} (or smaller) and \code{Inf} for
any \code{j >= y_max + 1}, where \code{y_max} is a known upper bound on the data \code{y}
(if specified).
}
\examples{
# Standard cases:
a_j(1)
a_j(20)

# Boundary cases:
a_j(0)
a_j(20, y_max = 15)

}
