% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{init_lm_ridge}
\alias{init_lm_ridge}
\title{Initialize linear regression parameters assuming a ridge prior}
\usage{
init_lm_ridge(y, X, X_test = NULL)
}
\arguments{
\item{y}{\code{n x 1} vector of data}

\item{X}{\code{n x p} matrix of predictors}

\item{X_test}{\code{n0 x p} matrix of predictors at test points (default is NULL)}
}
\value{
a named list \code{params} containing at least
\enumerate{
\item \code{mu}: vector of conditional means (fitted values)
\item \code{sigma}: the conditional standard deviation
\item \code{coefficients}: a named list of parameters that determine \code{mu}
}
Additionally, if X_test is not NULL, then the list includes an element
\code{mu_test}, the vector of conditional means at the test points
}
\description{
Initialize the parameters for a linear regression model assuming a
ridge prior for the (non-intercept) coefficients. The number of predictors
\code{p} may exceed the number of observations \code{n}.
}
\note{
The parameters in \code{coefficients} are:
\itemize{
\item \code{beta}: the \code{p x 1} vector of regression coefficients
\item \code{sigma_beta}: the prior standard deviation for the (non-intercept)
components of \code{beta}
}
}
\keyword{internal}
