% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ahmad2017.R, R/BoxesM.R, R/Chaipitak2013.R,
%   R/DocumentHomogeneityStatistics.R, R/Ishii2016.R, R/Schott2001.R,
%   R/Schott2007.R, R/Srivastava2007.R, R/Srivastava2014.R,
%   R/SrivastavaYanagihara2010.R
\name{Ahmad2017}
\alias{Ahmad2017}
\alias{BoxesM}
\alias{Chaipitak2013}
\alias{homogeneityStatistics}
\alias{Ishii2016}
\alias{Schott2001}
\alias{Schott2007}
\alias{Srivastava2007}
\alias{Srivastava2014}
\alias{SrivastavaYanagihara2010}
\title{Tests for Homogeneity of Covariance Matrices}
\usage{
Ahmad2017(x, ...)

BoxesM(x, ...)

Chaipitak2013(x, ...)

Ishii2016(x, ...)

Schott2001(x, ...)

Schott2007(x, ...)

Srivastava2007(x, ...)

Srivastava2014(x, ...)

SrivastavaYanagihara2010(x, ...)
}
\arguments{
\item{x}{data as a list of matrices}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of homogeneity of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of homogeneity of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Performs tests for homogeneity of 2 and k covariance matrices.
}
\examples{
irisSpecies <- unique(iris$Species)

iris_ls <- lapply(irisSpecies, 
    function(x){as.matrix(iris[iris$Species == x, 1:4])}
                 )
                 
names(iris_ls) <- irisSpecies

Ahmad2017(iris_ls)
}
\references{
Ahmad, R. (2017). Location-invariant test of homogeneity 
of large-dimensional covariance matrices. Journal of Statistical 
Theory and Practice, 11(4):731-745. 
\href{http://doi.org/10.1080/15598608.2017.1308895}{10.1080/15598608.2017.1308895}

Chaipitak, S. and Chongcharoen, S. (2013). A test for 
testing the equality of two covariance matrices for high-dimensional 
data. Journal of Applied Sciences, 13(2):270-277. 
\href{http://doi.org/10.3923/jas.2013.270.277}{10.3923/jas.2013.270.277}

Ishii, A., Yata, K., and Aoshima, M. (2016). Asymptotic 
properties of the first pricipal component and equality tests of 
covariance matrices in high-dimesion, low-sample-size context. Journal 
of Statistical Planning and Inference, 170:186-199. 
\href{http://doi.org/10.1016/j.jspi.2015.10.007}{10.1016/j.jspi.2015.10.007}

Schott, J (2001). Some Tests for the Equality of Covariance
Matrices. Journal of Statistical Planniing and Inference. 94(1), 25-36. 
\href{http://doi.org/10.1016/S0378-3758(00)00209-3}{10.1016/S0378-3758(00)00209-3}

Schott, J. (2007). A test for the equality of covariance 
matrices when the dimension is large relative to the sample sizes. 
Computational Statistics & Data Analysis, 51(12):6535-6542. 
\href{http://doi.org/10.1016/j.csda.2007.03.004}{10.1016/j.csda.2007.03.004}

Srivastava, M. S. (2007). Testing the equality of two 
covariance matrices and independence of two sub-vectors with fewer 
observations than the dimension. InInternational Conference on 
Advances in InterdisciplinaryStistics and Combinatorics, University 
of North Carolina at Greensboro, NC, USA.

Srivastava, M., Yanagihara, H., and Kubokawa T. (2014). 
Tests for covariance matrices in high dimension with less sample size. 
Journal of Multivariate Analysis, 130:289-309. 
\href{http://doi.org/10.1016/j.jmva.2014.06.003}{10.1016/j.jmva.2014.06.003}

Srivastava, M. and Yanagihara, H. (2010). Testing the 
equality of several covariance matrices with fewer observation that 
the dimension. Journal of Multivariate Analysis, 101(6):1319-1329. 
\href{http://doi.org/10.1016/j.jmva.2009.12.010}{10.1016/j.jmva.2009.12.010}
}
\seealso{
Other Testing for Homogeneity of Covariance Matrices: \code{\link{homogeneityCovariances}}
}
\concept{Testing for Homogeneity of Covariance Matrices}
