% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{test_covequal}
\alias{test_covequal}
\title{Test for equality of covariance matrices}
\usage{
test_covequal(X, Y, inference = c("TW", "permutation"), nperm)
}
\arguments{
\item{X}{matrix of size n1 x p}

\item{Y}{matrix of size n2 x p}

\item{inference}{Method for computing p-value.}

\item{nperm}{Number of permutations. See details.}
}
\value{
A list containing the test statistic and the p-value.
}
\description{
Uses Roy's union-intersection principle for testing for equality of covariance matrices between
two samples. Also provides p-values.
}
\examples{
X <- matrix(rnorm(50*100), ncol = 100)
Y <- matrix(rnorm(40*100), ncol = 100)
test_covequal(X, Y, inference = "TW", nperm = 10)
}
